package com.ejie.ab04b.service;

import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;

import com.ejie.ab04b.model.Promotor;

/**
 * Ab0485s00Service generated by UDA, 21-feb-2017 13:23:33.
 * 
 * @author UDA
 */

public interface PromotorService {

	/**
	 * Inserts a single row in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  Ab0485s00
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the promotor
	 */
	Promotor add(Promotor ab0485s00);

	/**
	 * Updates a single row in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  Ab0485s00
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the promotor
	 */
	Promotor update(Promotor ab0485s00);

	/**
	 * Finds a single row in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  Ab0485s00
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the promotor
	 */
	Promotor find(Promotor ab0485s00);

	/**
	 * Finds a single row in the Ab0483s00 table.
	 * 
	 *  ab0485s00
	 *            Promotor
	 *  List<Promotor>
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the list
	 */
	List<Promotor> findPromotorMaxFecAlta(Promotor ab0485s00);

	/**
	 * Counts rows in the Promotor table.
	 * 
	 *  ab0485s00
	 *            Promotor
	 *  Long
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the long
	 */
	long buscarHayPromotorPrincipal(Promotor ab0485s00);

	/**
	 * Deletes a single row in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 */
	void remove(Promotor ab0485s00);

	/**
	 * Finds a list of rows in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0485s00>
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<Promotor> findAll(Promotor ab0485s00, JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Ab0485s00 table using like.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0485s00>
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<Promotor> findAllLike(Promotor ab0485s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab0485s00 table.
	 * 
	 *  filterAb0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	void removeMultiple(Promotor filterAb0485s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Ab0485s00 table.
	 * 
	 *  filterAb0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0485s00>
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<Promotor> filter(Promotor filterAb0485s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Ab0485s00 table.
	 * 
	 *  filterAb0485s00
	 *            Ab0485s00
	 *  searchAb0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0485s00>>
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param searchAb0485s00 the search ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<Promotor>> search(Promotor filterAb0485s00,
			Promotor searchAb0485s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Ab0485s00 table.
	 * 
	 *  filterAb0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	Object reorderSelection(Promotor filterAb0485s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab0485s00 table.
	 * 
	 *  filterAb0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<JerarquiaDto<Ab0485s00>>
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<JerarquiaDto<Promotor>> jerarquia(
			Promotor filterAb0485s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Ab0485s00 table.
	 * 
	 *  filterAb0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  JQGridResponseDto<JerarquiaDto<Ab0485s00>>
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<JerarquiaDto<Promotor>> jerarquiaChildren(
			Promotor filterAb0485s00, JQGridRequestDto jqGridRequestDto);

}
